package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.impl.campaign.ids.HullMods;
import data.scripts.everyframe.SWP_BlockedHullmodDisplayScript;
import java.util.HashSet;
import java.util.Set;

public class SWP_AdditionalCrewQuarters extends BaseHullMod {

    public static final float MAXCREW_BONUS0 = 20f;
    public static final float MAXCREW_BONUS1 = 40f;
    public static final float MAXCREW_BONUS2 = 60f;
    public static final float MAXCREW_BONUS3 = 100f;

    private static final Set<String> BLOCKED_HULLMODS = new HashSet<>(1);

    static {
        BLOCKED_HULLMODS.add("ilk_AICrew");
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        for (String tmp : BLOCKED_HULLMODS) {
            if (ship.getVariant().getHullMods().contains(tmp)) {
                ship.getVariant().removeMod(tmp);
                SWP_BlockedHullmodDisplayScript.showBlocked(ship);
            }
        }
    }

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (hullSize == HullSize.FRIGATE) {
            stats.getMaxCrewMod().modifyFlat(id, MAXCREW_BONUS0);
        }
        if (hullSize == HullSize.DESTROYER) {
            stats.getMaxCrewMod().modifyFlat(id, MAXCREW_BONUS1);
        }
        if (hullSize == HullSize.CRUISER) {
            stats.getMaxCrewMod().modifyFlat(id, MAXCREW_BONUS2);
        }
        if (hullSize == HullSize.CAPITAL_SHIP) {
            stats.getMaxCrewMod().modifyFlat(id, MAXCREW_BONUS3);
        }
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "" + (int) MAXCREW_BONUS0;
        }
        if (index == 1) {
            return "" + (int) MAXCREW_BONUS1;
        }
        if (index == 2) {
            return "" + (int) MAXCREW_BONUS2;
        }
        if (index == 3) {
            return "" + (int) MAXCREW_BONUS3;
        }
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("diableavionics_cramped")) {
            return "Cannot be installed on a cramped hull";
        }
        if (ship.getVariant().hasHullMod("ilk_AICrew")) {
            return "Incompatible with AI Crew";
        }
        if (ship.getVariant().hasHullMod("cargo_expansion")) {
            return "Incompatible with Expanded Cargo";
        }
        if (ship.getVariant().hasHullMod("fuel_expansion")) {
            return "Incompatible with Expanded Fuel Tanks";
        }
        if (ship.getVariant().hasHullMod(HullMods.AUTOMATED)) {
            return "Can not be installed on automated ships";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("ilk_AICrew")
                && !ship.getVariant().getHullMods().contains("cargo_expansion")
                && !ship.getVariant().getHullMods().contains("fuel_expansion")
                && !ship.getVariant().getHullMods().contains(HullMods.AUTOMATED)
                && !ship.getVariant().getHullMods().contains("diableavionics_cramped");
    }
}
